// LootData.cs
// Author: Oak (ssalter)
// Version: 1.0
// Requirements: Runuo 2.0, XmlSpawner2
// Server Tested with: 2.0 build 64
// Revision Date: 7/1/2006
// Purpose: Player can type 'grab options' to get a gump and select what types of items they want to transfer
// to their lootbag when using the 'claim' command. Uses XMLAttachment for loot options

using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;

namespace Server.Engines.XmlSpawner2
{
	public class HlavniQuest : XmlAttachment
	{
		private DateTime m_NextRepeat;
		private DateTime m_Started;
		private bool m_InProgress;
		private bool m_KilledDragon;
		private int m_Count;
		private DateTime m_NextPandemonium;

		[CommandProperty( AccessLevel.GameMaster )]
		public DateTime NextRepeat { get { return m_NextRepeat; } set { m_NextRepeat  = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public DateTime Started { get { return m_Started; } set { m_Started  = value; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public bool InProgress { get { return m_InProgress; } set { m_InProgress  = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool KilledDragon { get { return m_KilledDragon; } set { m_KilledDragon  = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Count { get { return m_Count; } set { m_Count  = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public DateTime NextPandemonium { get { return m_NextPandemonium; } set { m_NextPandemonium  = value; } }

		public HlavniQuest(ASerial serial) : base(serial)
		{
		}

		[Attachable]
		public HlavniQuest()
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize(writer);

			writer.Write( (int) 1 );
			
			writer.Write(m_NextPandemonium);
			
			// version 0
			writer.Write(m_InProgress);
			writer.Write(m_KilledDragon);
			writer.Write(m_NextRepeat);
			writer.Write(m_Started);
			writer.Write(m_Count);
		}
		
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 1:
					{
          			m_NextPandemonium = reader.ReadDateTime();
                  goto case 0;
					}
				case 0:
					{
          			m_InProgress = reader.ReadBool();
          			m_KilledDragon = reader.ReadBool();
          			m_NextRepeat = reader.ReadDateTime();
          			m_Started = reader.ReadDateTime();
          			m_Count = reader.ReadInt();
						break;
					}
			}
		}
	}
}
